```php
<!DOCTYPE html>
<html lang="sk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>O nás - E-známka Slovensko | Náš tím</title>
    <meta name="description" content="Spoznajte náš tím expertov, ktorí vám pomáhajú s informáciami o elektronickej diaľničnej známke na Slovensku.">
    <link rel="icon" type="image/jpeg" href="images/logo.jpg">
    
    <meta property="og:title" content="O nás - E-známka Slovensko">
    <meta property="og:description" content="Spoznajte náš tím expertov.">
    <meta property="og:image" content="https://ezamki.com/images/logo.jpg">
    <meta property="og:url" content="https://ezamki.com/about.php">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="O nás - E-známka Slovensko">
    <meta name="twitter:description" content="Spoznajte náš tím expertov.">
    
    <meta name="project-theme" content="travel">
    <meta name="about-photo-count" content="5">
    <meta name="about-gender" content="female,female,male,female,male">
    
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "AboutPage",
        "name": "O nás - E-známka SK",
        "description": "Informácie o našom tíme",
        "url": "https://ezamki.com/about.php"
    }
    </script>
    
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXXXXX"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-XXXXXXXXXX');
    </script>
    
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', 'XXXXXXXXXXXXXXXXX');
        fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=XXXXXXXXXXXXXXXXX&ev=PageView&noscript=1"/></noscript>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        header {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: #667eea;
        }
        
        .logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .logo h1 {
            font-size: 24px;
            font-weight: bold;
        }
        
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        
        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            transition: color 0.3s;
            font-size: 16px;
        }
        
        nav a:hover {
            color: #667eea;
        }
        
        .page-hero {
            background: linear-gradient(rgba(102, 126, 234, 0.9), rgba(118, 75, 162, 0.9)), url('images/3.jpg');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .page-hero h2 {
            font-size: 48px;
            margin-bottom: 15px;
        }
        
        .page-hero p {
            font-size: 20px;
        }
        
        .main-content {
            background: white;
            margin: -30px auto 40px;
            border-radius: 20px;
            padding: 60px 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        
        .about-intro {
            text-align: center;
            margin-bottom: 60px;
        }
        
        .about-intro h3 {
            font-size: 32px;
            color: #667eea;
            margin-bottom: 20px;
        }
        
        .about-intro p {
            font-size: 18px;
            line-height: 1.8;
            color: #666;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .team-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 40px;
            margin-top: 50px;
        }
        
        .team-member {
            text-align: center;
            background: #f8f9fa;
            padding: 30px;
            border-radius: 15px;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .team-member:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
        }
        
        .team-member img {
            width: 400px;
            height: 400px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 20px;
            border: 5px solid #667eea;
            max-width: 100%;
        }
        
        .team-member h3 {
            color: #667eea;
            font-size: 24px;
            margin-bottom: 10px;
        }
        
        .team-member .position {
            color: #764ba2;
            font-weight: bold;
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .team-member .bio {
            color: #666;
            line-height: 1.6;
            font-size: 15px;
        }
        
        .values-section {
            margin-top: 60px;
            padding: 40px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            color: white;
        }
        
        .values-section h3 {
            text-align: center;
            font-size: 32px;
            margin-bottom: 40px;
        }
        
        .values-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
        }
        
        .value-item {
            text-align: center;
            padding: 20px;
        }
        
        .value-item i {
            font-size: 48px;
            margin-bottom: 15px;
        }
        
        .value-item h4 {
            font-size: 22px;
            margin-bottom: 10px;
        }
        
        footer {
            background: #2d3436;
            color: white;
            padding: 50px 0 20px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 30px;
        }
        
        .footer-section h3 {
            color: #667eea;
            margin-bottom: 20px;
        }
        
        .footer-section ul {
            list-style: none;
        }
        
        .footer-section ul li {
            margin-bottom: 10px;
        }
        
        .footer-section a {
            color: #ddd;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer-section a:hover {
            color: #667eea;
        }
        
        .contact-info {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #444;
            color: #aaa;
        }
        
        .cookie-banner {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(45, 52, 54, 0.98);
            color: white;
            padding: 25px;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.3);
            z-index: 10000;
            display: none;
        }
        
        .cookie-banner.show {
            display: block;
        }
        
        .cookie-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .cookie-text {
            flex: 1;
            min-width: 300px;
        }
        
        .cookie-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .cookie-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            transition: opacity 0.3s;
        }
        
        .cookie-btn:hover {
            opacity: 0.8;
        }
        
        .cookie-accept {
            background: #667eea;
            color: white;
        }
        
        .cookie-decline {
            background: #ddd;
            color: #333;
        }
        
        .cookie-settings {
            background: transparent;
            color: white;
            border: 1px solid white;
        }
        
        @media (max-width: 768px) {
            nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .page-hero h2 {
                font-size: 32px;
            }
            
            .header-content {
                flex-direction: column;
                gap: 20px;
            }
            
            .team-member img {
                width: 100%;
                height: auto;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <a href="index.php" class="logo">
                    <img src="images/logo.jpg" alt="E-známka Logo">
                    <h1>E-známka SK</h1>
                </a>
                <nav>
                    <ul>
                        <li><a href="index.php"><i class="fas fa-home"></i> Domov</a></li>
                        <li><a href="blog.php"><i class="fas fa-blog"></i> Blog</a></li>
                        <li><a href="about.php"><i class="fas fa-users"></i> O nás</a></li>
                        <li><a href="contact.php"><i class="fas fa-envelope"></i> Kontakt</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <h2><i class="fas fa-users"></i> O nás</h2>
            <p>Spoznajte náš skúsený tím</p>
        </div>
    </section>

    <div class="container">
        <div class="main-content">
            <div class="about-intro">
                <h3>Kto sme?</h3>
                <p>Sme tím nadšencov, ktorí sa venujú poskytovaniu komplexných informácií o elektronickej diaľničnej známke na Slovensku. Naším cieľom je uľahčiť turistom a vodičom orientáciu v systéme e-známky a zabezpečiť, aby každý mal prístup k aktuálnym a presným informáciám. S viacročnými skúsenosťami v oblasti dopravy a cestovného ruchu prinášame odborné rady a praktické tipy.</p>
            </div>

            <div class="team-grid">
                <div class="team-member">
                    <img src="images/team_1.jpg" width="400" height="400" alt="Team member 1"/>
                    <h3>Zuzana Horvátová</h3>
                    <p class="position">Hlavná editorka</p>
                    <p class="bio">Zuzana má viac ako 10 rokov skúseností v oblasti dopravného práva a je odborníčkou na legislatívu týkajúcu sa diaľničných poplatkov. Venuje sa aj vzdelávaniu vodičov o pravidlách cestnej premávky.</p>
                </div>
                
                <div class="team-member">
                    <img src="images/team_2.jpg" width="400" height="400" alt="Team member 2"/>
                    <h3>Martina Kováčová</h3>
                    <p class="position">Obsahová manažérka</p>
                    <p class="bio">Martina sa špecializuje na tvorbu užívateľsky prívetivého obsahu. Jej cieľom je, aby každý návštevník našej stránky našiel odpovede na svoje otázky rýchlo a jednoducho.</p>
                </div>
                
                <div class="team-member">
                    <img src="images/team_3.jpg" width="400" height="400" alt="Team member 3"/>
                    <h3>Peter Novák</h3>
                    <p class="position">Technický konzultant</p>
                    <p class="bio">Peter má bohaté skúsenosti v oblasti IT a elektronických platobných systémov. Zaoberá sa technickou stránkou fungovania e-známky a radí klientom pri riešení technických problémov.</p>
                </div>
                
                <div class="team-member">
                    <img src="images/team_4.jpg" width="400" height="400" alt="Team member 4"/>
                    <h3>Lucia Baláková</h3>
                    <p class="position">Zákaznícka podpora</p>
                    <p class="bio">Lucia je tvárou nášho tímu v kontakte s klientmi. S jej pomocou dostanete odpovede na všetky vaše otázky a vyriešite akékoľvek problémy spojené s e-známkou.</p>
                </div>
                
                <div class="team-member">
                    <img src="images/team_5.jpg" width="400" height="400" alt="Team member 5"/>
                    <h3>Tomáš Varga</h3>
                    <p class="position">Analytik a výskumník</p>
                    <p class="bio">Tomáš sleduje trendy v oblasti dopravy a cestovného ruchu. Jeho analýzy pomáhajú lepšie pochopiť potreby vodičov a turistov navštevujúcich Slovensko.</p>
                </div>
            </div>

            <div class="values-section">
                <h3>Naše hodnoty</h3>
                <div class="values-grid">
                    <div class="value-item">
                        <i class="fas fa-check-circle"></i>
                        <h4>Presnosť</h4>
                        <p>Poskytujeme iba overené a aktuálne informácie</p>
                    </div>
                    <div class="value-item">
                        <i class="fas fa-heart"></i>
                        <h4>Zákaznícky prístup</h4>
                        <p>Vaše potreby sú pre nás na prvom mieste</p>
                    </div>
                    <div class="value-item">
                        <i class="fas fa-lightbulb"></i>
                        <h4>Inovácia</h4>
                        <p>Neustále hľadáme lepšie spôsoby, ako vám pomôcť</p>
                    </div>
                    <div class="value-item">
                        <i class="fas fa-shield-alt"></i>
                        <h4>Spoľahlivosť</h4>
                        <p>Môžete sa na nás vždy spoľahnúť</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>E-známka SK</h3>
                    <p>Váš spoľahlivý sprievodca svetom elektronických diaľničných známok na Slovensku.</p>
                    <p style="margin-top: 15px;"><strong>IČO:</strong> 91533494</p>
                </div>
                
                <div class="footer-section">
                    <h3>Rýchle odkazy</h3>
                    <ul>
                        <li><a href="index.php">Domov</a></li>
                        <li><a href="blog.php">Blog</a></li>
                        <li><a href="about.php">O nás</a></li>
                        <li><a href="contact.php">Kontakt</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Právne informácie</h3>
                    <ul>
                        <li><a href="privacy-policy.php">Ochrana osobných údajov</a></li>
                        <li><a href="terms-conditions.php">Podmienky používania</a></li>
                        <li><a href="refund-policy.php">Reklamačný poriadok</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Kontakt</h3>
                    <div class="contact-info">
                        <i class="fas fa-map-marker-alt"></i>
                        <span>Mišík Drive 86122<br>572 56 Lipovec, Slovakia</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+2670233649327</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <span>info@ezamki.com</span>
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; 2025 ezamki.com - Všetky práva vyhradené</p>
            </div>
        </div>
    </footer>

    <div class="cookie-banner" id="cookieBanner">
        <div class="cookie-content">
            <div class="cookie-text">
                <h3><i class="fas fa-cookie-bite"></i> Používame cookies</h3>
                <p>Tento web používa cookies na zlepšenie vášho zážitku, analýzu návštevnosti a personalizáciu obsahu. Viac informácií nájdete v našej <a href="privacy-policy.php" style="color: #667eea;">Politike ochrany osobných údajov</a>.</p>
            </div>
            <div class="cookie-buttons">
                <button class="cookie-btn cookie-accept" onclick="acceptCookies()">
                    <i class="fas fa-check"></i> Prijať všetky
                </button>
                <button class="cookie-btn cookie-decline" onclick="declineCookies()">
                    <i class="fas fa-times"></i> Odmietnuť
                </button>
                <button class="cookie-btn cookie-settings" onclick="acceptCookies()">
                    <i class="fas fa-cog"></i> Nastavenia
                </button>
            </div>
        </div>
    </div>

    <script>
        window.onload = function() {
            if (!localStorage.getItem('cookiesAccepted')) {
                document.getElementById('cookieBanner').classList.add('show');
            }
        };

        function acceptCookies() {
            localStorage.setItem('cookiesAccepted', 'true');
            document.getElementById('cookieBanner').classList.remove('show');
        }

        function declineCookies() {
            localStorage.setItem('cookiesAccepted', 'false');
            document.getElementById('cookieBanner').classList.remove('show');
        }
    </script>
</body>
</html>
```
