```php
<!DOCTYPE html>
<html lang="sk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kontakt - E-známka Slovensko</title>
    <meta name="description" content="Kontaktujte nás pre akékoľvek otázky týkajúce sa elektronickej diaľničnej známky na Slovensku. Sme tu pre vás.">
    <link rel="icon" type="image/jpeg" href="images/logo.jpg">
    
    <meta property="og:title" content="Kontakt - E-známka Slovensko">
    <meta property="og:description" content="Kontaktujte nás pre akékoľvek otázky.">
    <meta property="og:image" content="https://ezamki.com/images/logo.jpg">
    <meta property="og:url" content="https://ezamki.com/contact.php">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Kontakt - E-známka Slovensko">
    <meta name="twitter:description" content="Kontaktujte nás pre akékoľvek otázky.">
    
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "ContactPage",
        "name": "Kontakt - E-známka SK",
        "description": "Kontaktné informácie",
        "url": "https://ezamki.com/contact.php"
    }
    </script>
    
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXXXXX"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-XXXXXXXXXX');
    </script>
    
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', 'XXXXXXXXXXXXXXXXX');
        fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=XXXXXXXXXXXXXXXXX&ev=PageView&noscript=1"/></noscript>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        header {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: #667eea;
        }
        
        .logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .logo h1 {
            font-size: 24px;
            font-weight: bold;
        }
        
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        
        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            transition: color 0.3s;
            font-size: 16px;
        }
        
        nav a:hover {
            color: #667eea;
        }
        
        .page-hero {
            background: linear-gradient(rgba(102, 126, 234, 0.9), rgba(118, 75, 162, 0.9)), url('images/4.jpg');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .page-hero h2 {
            font-size: 48px;
            margin-bottom: 15px;
        }
        
        .page-hero p {
            font-size: 20px;
        }
        
        .main-content {
            background: white;
            margin: -30px auto 40px;
            border-radius: 20px;
            padding: 60px 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        
        .contact-wrapper {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 50px;
            margin-top: 40px;
        }
        
        .contact-info-section {
            padding: 30px;
        }
        
        .contact-info-section h3 {
            color: #667eea;
            font-size: 28px;
            margin-bottom: 30px;
        }
        
        .info-item {
            display: flex;
            align-items: flex-start;
            gap: 20px;
            margin-bottom: 30px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            transition: transform 0.3s;
        }
        
        .info-item:hover {
            transform: translateX(5px);
        }
        
        .info-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            flex-shrink: 0;
        }
        
        .info-content h4 {
            color: #667eea;
            margin-bottom: 5px;
        }
        
        .info-content p {
            color: #666;
        }
        
        .contact-form {
            padding: 30px;
        }
        
        .contact-form h3 {
            color: #667eea;
            font-size: 28px;
            margin-bottom: 30px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .form-group textarea {
            min-height: 150px;
            resize: vertical;
        }
        
        .submit-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 40px;
            border: none;
            border-radius: 25px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s, box-shadow 0.3s;
            width: 100%;
        }
        
        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .success-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 10001;
            align-items: center;
            justify-content: center;
        }
        
        .success-modal.show {
            display: flex;
        }
        
        .modal-content {
            background: white;
            padding: 40px;
            border-radius: 20px;
            text-align: center;
            max-width: 500px;
            animation: slideIn 0.3s ease;
        }
        
        @keyframes slideIn {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .modal-content i {
            font-size: 64px;
            color: #667eea;
            margin-bottom: 20px;
        }
        
        .modal-content h3 {
            color: #667eea;
            font-size: 28px;
            margin-bottom: 15px;
        }
        
        .modal-content p {
            color: #666;
            margin-bottom: 25px;
        }
        
        .modal-btn {
            background: #667eea;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 25px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
        }
        
        footer {
            background: #2d3436;
            color: white;
            padding: 50px 0 20px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 30px;
        }
        
        .footer-section h3 {
            color: #667eea;
            margin-bottom: 20px;
        }
        
        .footer-section ul {
            list-style: none;
        }
        
        .footer-section ul li {
            margin-bottom: 10px;
        }
        
        .footer-section a {
            color: #ddd;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer-section a:hover {
            color: #667eea;
        }
        
        .contact-info {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #444;
            color: #aaa;
        }
        
        .cookie-banner {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(45, 52, 54, 0.98);
            color: white;
            padding: 25px;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.3);
            z-index: 10000;
            display: none;
        }
        
        .cookie-banner.show {
            display: block;
        }
        
        .cookie-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .cookie-text {
            flex: 1;
            min-width: 300px;
        }
        
        .cookie-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .cookie-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            transition: opacity 0.3s;
        }
        
        .cookie-btn:hover {
            opacity: 0.8;
        }
        
        .cookie-accept {
            background: #667eea;
            color: white;
        }
        
        .cookie-decline {
            background: #ddd;
            color: #333;
        }
        
        .cookie-settings {
            background: transparent;
            color: white;
            border: 1px solid white;
        }
        
        @media (max-width: 768px) {
            nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .page-hero h2 {
                font-size: 32px;
            }
            
            .header-content {
                flex-direction: column;
                gap: 20px;
            }
            
            .contact-wrapper {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <a href="index.php" class="logo">
                    <img src="images/logo.jpg" alt="E-známka Logo">
                    <h1>E-známka SK</h1>
                </a>
                <nav>
                    <ul>
                        <li><a href="index.php"><i class="fas fa-home"></i> Domov</a></li>
                        <li><a href="blog.php"><i class="fas fa-blog"></i> Blog</a></li>
                        <li><a href="about.php"><i class="fas fa-users"></i> O nás</a></li>
                        <li><a href="contact.php"><i class="fas fa-envelope"></i> Kontakt</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class="page-hero">
        <div class="container">
            <h2><i class="fas fa-envelope"></i> Kontaktujte nás</h2>
            <p>Radi vám pomôžeme s vašimi otázkami</p>
        </div>
    </section>

    <div class="container">
        <div class="main-content">
            <div class="contact-wrapper">
                <div class="contact-info-section">
                    <h3>Kontaktné informácie</h3>
                    
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="info-content">
                            <h4>Adresa</h4>
                            <p>Mišík Drive 86122<br>572 56 Lipovec<br>Slovakia</p>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="info-content">
                            <h4>Telefón</h4>
                            <p>+2670233649327</p>
                            <p>Pondelok - Piatok: 9:00 - 17:00</p>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="info-content">
                            <h4>Email</h4>
                            <p>info@ezamki.com</p>
                            <p>Odpovieme do 24 hodín</p>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-building"></i>
                        </div>
                        <div class="info-content">
                            <h4>Registračné číslo</h4>
                            <p>IČO: 91533494</p>
                        </div>
                    </div>
                </div>
                
                <div class="contact-form">
                    <h3>Napíšte nám</h3>
                    <form id="contactForm" onsubmit="return handleSubmit(event)">
                        <div class="form-group">
                            <label for="name"><i class="fas fa-user"></i> Vaše meno *</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="email"><i class="fas fa-envelope"></i> Email *</label>
                            <input type="email" id="email" name="email" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="phone"><i class="fas fa-phone"></i> Telefón</label>
                            <input type="tel" id="phone" name="phone">
                        </div>
                        
                        <div class="form-group">
                            <label for="message"><i class="fas fa-comment"></i> Správa *</label>
                            <textarea id="message" name="message" required></textarea>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <i class="fas fa-paper-plane"></i> Odoslať správu
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="success-modal" id="successModal">
        <div class="modal-content">
            <i class="fas fa-check-circle"></i>
            <h3>Ďakujeme!</h3>
            <p>Vaša správa bola úspešne odoslaná. Odpovieme vám čo najskôr.</p>
            <button class="modal-btn" onclick="closeModal()">Zavrieť</button>
        </div>
    </div>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>E-známka SK</h3>
                    <p>Váš spoľahlivý sprievodca svetom elektronických diaľničných známok na Slovensku.</p>
                    <p style="margin-top: 15px;"><strong>IČO:</strong> 91533494</p>
                </div>
                
                <div class="footer-section">
                    <h3>Rýchle odkazy</h3>
                    <ul>
                        <li><a href="index.php">Domov</a></li>
                        <li><a href="blog.php">Blog</a></li>
                        <li><a href="about.php">O nás</a></li>
                        <li><a href="contact.php">Kontakt</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Právne informácie</h3>
                    <ul>
                        <li><a href="privacy-policy.php">Ochrana osobných údajov</a></li>
                        <li><a href="terms-conditions.php">Podmienky používania</a></li>
                        <li><a href="refund-policy.php">Reklamačný poriadok</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Kontakt</h3>
                    <div class="contact-info">
                        <i class="fas fa-map-marker-alt"></i>
                        <span>Mišík Drive 86122<br>572 56 Lipovec, Slovakia</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+2670233649327</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <span>info@ezamki.com</span>
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; 2025 ezamki.com - Všetky práva vyhradené</p>
            </div>
        </div>
    </footer>

    <div class="cookie-banner" id="cookieBanner">
        <div class="cookie-content">
            <div class="cookie-text">
                <h3><i class="fas fa-cookie-bite"></i> Používame cookies</h3>
                <p>Tento web používa cookies na zlepšenie vášho zážitku, analýzu návštevnosti a personalizáciu obsahu. Viac informácií nájdete v našej <a href="privacy-policy.php" style="color: #667eea;">Politike ochrany osobných údajov</a>.</p>
            </div>
            <div class="cookie-buttons">
                <button class="cookie-btn cookie-accept" onclick="acceptCookies()">
                    <i class="fas fa-check"></i> Prijať všetky
                </button>
                <button class="cookie-btn cookie-decline" onclick="declineCookies()">
                    <i class="fas fa-times"></i> Odmietnuť
                </button>
                <button class="cookie-btn cookie-settings" onclick="acceptCookies()">
                    <i class="fas fa-cog"></i> Nastavenia
                </button>
            </div>
        </div>
    </div>

    <script>
        window.onload = function() {
            if (!localStorage.getItem('cookiesAccepted')) {
                document.getElementById('cookieBanner').classList.add('show');
            }
        };

        function acceptCookies() {
            localStorage.setItem('cookiesAccepted', 'true');
            document.getElementById('cookieBanner').classList.remove('show');
        }

        function declineCookies() {
            localStorage.setItem('cookiesAccepted', 'false');
            document.getElementById('cookieBanner').classList.remove('show');
        }

        function handleSubmit(event) {
            event.preventDefault();
            document.getElementById('successModal').classList.add('show');
            document.getElementById('contactForm').reset();
            return false;
        }

        function closeModal() {
            document.getElementById('successModal').classList.remove('show');
        }
    </script>
</body>
</html>
```
