```php
<!DOCTYPE html>
<html lang="sk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-známka Slovensko - Elektronická diaľničná známka FAQ</title>
    <meta name="description" content="Kompletný FAQ sprievodca elektronickou diaľničnou známkou pre Slovensko. Všetky informácie pre turistov o pravidlách a používaní e-známky.">
    <meta name="keywords" content="Slovakia vignette FAQ, e známka, vignette tourists, vignette rules, elektronická známka">
    <link rel="icon" type="image/jpeg" href="images/logo.jpg">
    
    <meta property="og:title" content="E-známka Slovensko - Elektronická diaľničná známka FAQ">
    <meta property="og:description" content="Kompletný FAQ sprievodca elektronickou diaľničnou známkou pre Slovensko.">
    <meta property="og:image" content="https://ezamki.com/images/logo.jpg">
    <meta property="og:url" content="https://ezamki.com/">
    <meta property="og:type" content="website">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="E-známka Slovensko - Elektronická diaľničná známka FAQ">
    <meta name="twitter:description" content="Kompletný FAQ sprievodca elektronickou diaľničnou známkou pre Slovensko.">
    <meta name="twitter:image" content="https://ezamki.com/images/logo.jpg">
    
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "FAQPage",
        "name": "E-známka Slovensko FAQ",
        "description": "Časté otázky o elektronickej diaľničnej známke",
        "url": "https://ezamki.com/"
    }
    </script>
    
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXXXXX"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-XXXXXXXXXX');
    </script>
    
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', 'XXXXXXXXXXXXXXXXX');
        fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=XXXXXXXXXXXXXXXXX&ev=PageView&noscript=1"/></noscript>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        header {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: #667eea;
        }
        
        .logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .logo h1 {
            font-size: 24px;
            font-weight: bold;
        }
        
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        
        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            transition: color 0.3s;
            font-size: 16px;
        }
        
        nav a:hover {
            color: #667eea;
        }
        
        .hero {
            background: linear-gradient(rgba(102, 126, 234, 0.9), rgba(118, 75, 162, 0.9)), url('images/1.jpg');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 100px 0;
            text-align: center;
        }
        
        .hero h2 {
            font-size: 48px;
            margin-bottom: 20px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .hero p {
            font-size: 20px;
            margin-bottom: 30px;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: white;
            color: #667eea;
            text-decoration: none;
            border-radius: 25px;
            font-weight: bold;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.3);
        }
        
        .main-content {
            background: white;
            margin: -50px auto 40px;
            border-radius: 20px;
            padding: 60px 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        
        .stats-banner {
            display: flex;
            justify-content: space-around;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px;
            border-radius: 15px;
            margin-bottom: 50px;
            color: white;
            flex-wrap: wrap;
        }
        
        .stat-item {
            text-align: center;
            padding: 20px;
        }
        
        .stat-number {
            font-size: 42px;
            font-weight: bold;
            display: block;
            margin-bottom: 10px;
        }
        
        .stat-label {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .inspiration-block {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            padding: 40px;
            border-radius: 15px;
            margin: 40px 0;
            color: white;
            text-align: center;
        }
        
        .inspiration-block h3 {
            font-size: 28px;
            margin-bottom: 20px;
        }
        
        .inspiration-quote {
            font-size: 20px;
            font-style: italic;
            line-height: 1.8;
            margin-bottom: 15px;
        }
        
        .faq-section {
            margin: 50px 0;
        }
        
        .faq-section h2 {
            font-size: 36px;
            color: #667eea;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .faq-item {
            background: #f8f9fa;
            margin-bottom: 20px;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .faq-question {
            padding: 20px;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: white;
            transition: background 0.3s;
        }
        
        .faq-question:hover {
            background: #f0f0f0;
        }
        
        .faq-question h3 {
            color: #667eea;
            font-size: 20px;
        }
        
        .faq-icon {
            font-size: 20px;
            color: #667eea;
            transition: transform 0.3s;
        }
        
        .faq-answer {
            padding: 0 20px;
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s, padding 0.3s;
        }
        
        .faq-answer.active {
            padding: 20px;
            max-height: 500px;
        }
        
        .blog-preview {
            margin: 50px 0;
        }
        
        .blog-preview h2 {
            font-size: 36px;
            color: #667eea;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .blog-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 30px;
        }
        
        .blog-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .blog-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        }
        
        .blog-card img {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
        
        .blog-card-content {
            padding: 20px;
        }
        
        .blog-card h3 {
            color: #667eea;
            margin-bottom: 10px;
            font-size: 22px;
        }
        
        .blog-card p {
            color: #666;
            margin-bottom: 15px;
        }
        
        .read-more {
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }
        
        footer {
            background: #2d3436;
            color: white;
            padding: 50px 0 20px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 30px;
        }
        
        .footer-section h3 {
            color: #667eea;
            margin-bottom: 20px;
        }
        
        .footer-section ul {
            list-style: none;
        }
        
        .footer-section ul li {
            margin-bottom: 10px;
        }
        
        .footer-section a {
            color: #ddd;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer-section a:hover {
            color: #667eea;
        }
        
        .contact-info {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #444;
            color: #aaa;
        }
        
        .cookie-banner {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(45, 52, 54, 0.98);
            color: white;
            padding: 25px;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.3);
            z-index: 10000;
            display: none;
        }
        
        .cookie-banner.show {
            display: block;
        }
        
        .cookie-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }
        
        .cookie-text {
            flex: 1;
            min-width: 300px;
        }
        
        .cookie-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .cookie-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            transition: opacity 0.3s;
        }
        
        .cookie-btn:hover {
            opacity: 0.8;
        }
        
        .cookie-accept {
            background: #667eea;
            color: white;
        }
        
        .cookie-decline {
            background: #ddd;
            color: #333;
        }
        
        .cookie-settings {
            background: transparent;
            color: white;
            border: 1px solid white;
        }
        
        @media (max-width: 768px) {
            nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .hero h2 {
                font-size: 32px;
            }
            
            .header-content {
                flex-direction: column;
                gap: 20px;
            }
            
            .stats-banner {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <a href="index.php" class="logo">
                    <img src="images/logo.jpg" alt="E-známka Logo">
                    <h1>E-známka SK</h1>
                </a>
                <nav>
                    <ul>
                        <li><a href="index.php"><i class="fas fa-home"></i> Domov</a></li>
                        <li><a href="blog.php"><i class="fas fa-blog"></i> Blog</a></li>
                        <li><a href="about.php"><i class="fas fa-users"></i> O nás</a></li>
                        <li><a href="contact.php"><i class="fas fa-envelope"></i> Kontakt</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <h2>E-známka Slovensko FAQ</h2>
            <p>Všetky odpovede na vaše otázky o elektronickej diaľničnej známke</p>
            <a href="#faq" class="btn">Preskúmať FAQ</a>
        </div>
    </section>

    <div class="container">
        <div class="main-content">
            <div class="stats-banner">
                <div class="stat-item">
                    <span class="stat-number" id="visitors">0</span>
                    <span class="stat-label">Návštevníkov dnes</span>
                </div>
                <div class="stat-item">
                    <span class="stat-number">24/7</span>
                    <span class="stat-label">Dostupnosť</span>
                </div>
                <div class="stat-item">
                    <span class="stat-number">100%</span>
                    <span class="stat-label">Online nákup</span>
                </div>
            </div>
            
            <div class="inspiration-block">
                <h3><i class="fas fa-quote-left"></i> Vaša denná inšpirácia</h3>
                <p class="inspiration-quote">"Cesta tisíc míľ začína jediným krokom. Cestujte bezpečne a s platnou diaľničnou známkou!"</p>
                <small>- Slovenský príslovie o cestovaní</small>
            </div>

            <section id="faq" class="faq-section">
                <h2><i class="fas fa-question-circle"></i> Často kladené otázky</h2>
                
                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Čo je elektronická diaľničná známka (e-známka)?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Elektronická diaľničná známka je moderný systém spoplatnenia diaľnic na Slovensku. Namiesto tradičnej nálepky na čelnom skle vozidla sa známka registruje elektronicky podľa evidenčného čísla vozidla (EČV). Po zakúpení sa údaje automaticky uložia do centrálneho systému a kontrola prebieha pomocou kamier.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Ako si môžem zakúpiť e-známku pre Slovensko?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>E-známku si môžete zakúpiť niekoľkými spôsobmi: online cez oficiálny web www.eznamka.sk, v mobilnej aplikácii, na čerpacích staniciach, v pobočkách Slovenskej pošty alebo v niektorých obchodoch. Pri nákupe budete potrebovať evidenčné číslo vozidla (EČV) a krajinu registrácie.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Aké typy e-známok sú dostupné?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Pre osobné vozidlá do 3,5 tony sú dostupné tri typy známok: ročná (platná 365 dní), 30-dňová a 10-dňová. Ceny sa líšia podľa dĺžky platnosti. Pre turistov navštevujúcich Slovensko na krátke obdobie je ideálna 10-dňová známka.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Kedy začína platiť e-známka po zakúpení?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>E-známka začína platiť až po 24 hodinách od zakúpenia. To znamená, že ak si kúpite známku dnes o 14:00, bude platná od zajtrajška o 14:00. Tento čas je potrebný na spracovanie údajov v systéme. Preto si známku zakúpte vopred!</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Potrebujem e-známku pre všetky cesty na Slovensku?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>E-známku potrebujete iba pre jazdu po diaľniciach a rýchlostných cestách označených príslušnými dopravnými značkami. Na bežných cestách prvej, druhej a tretej triedy známku nepotrebujete. Pred vstupom na diaľnicu sú umiestnené informačné tabule.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Čo sa stane, ak budem jazdiť bez platnej e-známky?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Jazda bez platnej e-známky je považovaná za priestupok. Pokuta môže byť až do výšky 300 EUR. Kontrola prebieha automaticky pomocou kamier, ktoré snímajú EČV vozidiel a porovnávajú ich s databázou. Pokutu môžete dostať aj poštou na adresu majiteľa vozidla.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Môžem preniesť e-známku na iné vozidlo?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>E-známka je viazaná na konkrétne evidenčné číslo vozidla a nie je prenosná. Ak zmeníte vozidlo, musíte si zakúpiť novú známku. V prípade predaja vozidla známka ostáva s vozidlom, nie s majiteľom.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question" onclick="toggleFaq(this)">
                        <h3>Ako si môžem skontrolovať platnosť svojej e-známky?</h3>
                        <span class="faq-icon"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Platnosť e-známky si môžete kedykoľvek overiť na oficiálnom webe www.eznamka.sk v sekcii "Kontrola platnosti". Potrebujete zadať EČV a krajinu registrácie. Odporúčame si uložiť potvrdenie o zakúpení alebo urobiť screenshot ako dôkaz.</p>
                    </div>
                </div>
            </section>

            <section class="blog-preview">
                <h2><i class="fas fa-newspaper"></i> Najnovšie články</h2>
                <div class="blog-grid">
                    <div class="blog-card">
                        <img src="images/2.jpg" alt="Blog post 1">
                        <div class="blog-card-content">
                            <h3>Kompletný sprievodca nákupom e-známky</h3>
                            <p>Zistite, ako si krok za krokom zakúpiť elektronickou diaľničnú známku pre Slovensko...</p>
                            <a href="post1.php" class="read-more">Čítať viac <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    
                    <div class="blog-card">
                        <img src="images/3.jpg" alt="Blog post 2">
                        <div class="blog-card-content">
                            <h3>Pravidlá používania diaľnic na Slovensku</h3>
                            <p>Všetko, čo potrebujete vedieť o pravidlách a predpisoch na slovenských diaľniciach...</p>
                            <a href="post2.php" class="read-more">Čítať viac <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    
                    <div class="blog-card">
                        <img src="images/4.jpg" alt="Blog post 3">
                        <div class="blog-card-content">
                            <h3>Tipy pre turistov: Cestovanie po Slovensku</h3>
                            <p>Praktické rady pre zahraničných návštevníkov cestujúcich autom po Slovensku...</p>
                            <a href="post3.php" class="read-more">Čítať viac <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>E-známka SK</h3>
                    <p>Váš spoľahlivý sprievodca svetom elektronických diaľničných známok na Slovensku.</p>
                    <p style="margin-top: 15px;"><strong>IČO:</strong> 91533494</p>
                </div>
                
                <div class="footer-section">
                    <h3>Rýchle odkazy</h3>
                    <ul>
                        <li><a href="index.php">Domov</a></li>
                        <li><a href="blog.php">Blog</a></li>
                        <li><a href="about.php">O nás</a></li>
                        <li><a href="contact.php">Kontakt</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Právne informácie</h3>
                    <ul>
                        <li><a href="privacy-policy.php">Ochrana osobných údajov</a></li>
                        <li><a href="terms-conditions.php">Podmienky používania</a></li>
                        <li><a href="refund-policy.php">Reklamačný poriadok</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Kontakt</h3>
                    <div class="contact-info">
                        <i class="fas fa-map-marker-alt"></i>
                        <span>Mišík Drive 86122<br>572 56 Lipovec, Slovakia</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+2670233649327</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <span>info@ezamki.com</span>
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; 2025 ezamki.com - Všetky práva vyhradené</p>
            </div>
        </div>
    </footer>

    <div class="cookie-banner" id="cookieBanner">
        <div class="cookie-content">
            <div class="cookie-text">
                <h3><i class="fas fa-cookie-bite"></i> Používame cookies</h3>
                <p>Tento web používa cookies na zlepšenie vášho zážitku, analýzu návštevnosti a personalizáciu obsahu. Viac informácií nájdete v našej <a href="privacy-policy.php" style="color: #667eea;">Politike ochrany osobných údajov</a>.</p>
            </div>
            <div class="cookie-buttons">
                <button class="cookie-btn cookie-accept" onclick="acceptCookies()">
                    <i class="fas fa-check"></i> Prijať všetky
                </button>
                <button class="cookie-btn cookie-decline" onclick="declineCookies()">
                    <i class="fas fa-times"></i> Odmietnuť
                </button>
                <button class="cookie-btn cookie-settings" onclick="acceptCookies()">
                    <i class="fas fa-cog"></i> Nastavenia
                </button>
            </div>
        </div>
    </div>

    <script>
        function toggleFaq(element) {
            const answer = element.nextElementSibling;
            const icon = element.querySelector('.faq-icon i');
            
            answer.classList.toggle('active');
            
            if (answer.classList.contains('active')) {
                icon.style.transform = 'rotate(180deg)';
            } else {
                icon.style.transform = 'rotate(0deg)';
            }
        }

        window.onload = function() {
            if (!localStorage.getItem('cookiesAccepted')) {
                document.getElementById('cookieBanner').classList.add('show');
            }
            
            let count = parseInt(localStorage.getItem('visitorCount') || '1247');
            count++;
            localStorage.setItem('visitorCount', count);
            
            let current = 0;
            const target = count;
            const increment = Math.ceil(target / 50);
            
            const counter = setInterval(() => {
                current += increment;
                if (current >= target) {
                    current = target;
                    clearInterval(counter);
                }
                document.getElementById('visitors').textContent = current.toLocaleString();
            }, 30);
        };

        function acceptCookies() {
            localStorage.setItem('cookiesAccepted', 'true');
            document.getElementById('cookieBanner').classList.remove('show');
        }

        function declineCookies() {
            localStorage.setItem('cookiesAccepted', 'false');
            document.getElementById('cookieBanner').classList.remove('show');
        }
    </script>
</body>
</html>
```
