<?php
?>
<!DOCTYPE html>
<html lang='sk'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Ochrana osobných údajov - E-známka Slovensko</title>
    <meta name='description' content='Politika ochrany osobných údajov pre ezamki.com - informácie o spracovaní vašich osobných údajov.'>
    <link rel='icon' type='image/jpeg' href='images/logo.jpg'>
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css'>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.8;
            color: #333;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        header {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: #667eea;
        }
        
        .logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .logo h1 {
            font-size: 24px;
            font-weight: bold;
        }
        
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        
        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        nav a:hover {
            color: #667eea;
        }
        
        .page-hero {
            background: linear-gradient(rgba(102, 126, 234, 0.9), rgba(118, 75, 162, 0.9));
            color: white;
            padding: 60px 0;
            text-align: center;
        }
        
        .page-hero h2 {
            font-size: 42px;
            margin-bottom: 10px;
        }
        
        .main-content {
            background: white;
            margin: -30px auto 40px;
            border-radius: 20px;
            padding: 60px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            max-width: 900px;
        }
        
        .main-content h3 {
            color: #667eea;
            font-size: 26px;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        
        .main-content h4 {
            color: #764ba2;
            font-size: 20px;
            margin-top: 20px;
            margin-bottom: 10px;
        }
        
        .main-content p {
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .main-content ul, .main-content ol {
            margin: 15px 0;
            padding-left: 30px;
        }
        
        .main-content li {
            margin-bottom: 8px;
        }
        
        .highlight-box {
            background: #f0f4ff;
            border-left: 5px solid #667eea;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        
        footer {
            background: #2d3436;
            color: white;
            padding: 30px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }
            
            nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .main-content {
                padding: 30px 20px;
            }
            
            .page-hero h2 {
                font-size: 28px;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class='container'>
            <div class='header-content'>
                <a href='index.php' class='logo'>
                    <img src='images/logo.jpg' alt='E-známka Logo'>
                    <h1>E-známka SK</h1>
                </a>
                <nav>
                    <ul>
                        <li><a href='index.php'><i class='fas fa-home'></i> Domov</a></li>
                        <li><a href='blog.php'><i class='fas fa-blog'></i> Blog</a></li>
                        <li><a href='about.php'><i class='fas fa-users'></i> O nás</a></li>
                        <li><a href='contact.php'><i class='fas fa-envelope'></i> Kontakt</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class='page-hero'>
        <div class='container'>
            <h2><i class='fas fa-shield-alt'></i> Ochrana osobných údajov</h2>
            <p>Politika ochrany súkromia</p>
        </div>
    </section>

    <div class='container'>
        <div class='main-content'>
            <p><strong>Dátum účinnosti:</strong> 1. január 2025</p>
            <p><strong>Posledná aktualizácia:</strong> 1. január 2025</p>

            <h3>1. Úvod</h3>
            <p>Vitajte na ezamki.com ("my", "nás", "náš" alebo "webová stránka"). Ochrana vášho súkromia je pre nás prioritou. Táto Politika ochrany osobných údajov vysvetľuje, ako zhromažďujeme, používame, zdieľame a chránime vaše osobné údaje v súlade s Nariadením EÚ 2016/679 (GDPR) a zákonom č. 18/2018 Z.z. o ochrane osobných údajov.</p>

            <div class='highlight-box'>
                <p><strong><i class='fas fa-info-circle'></i> Dôležité:</strong> Prevádzkovateľom tejto webovej stránky je informačný portál poskytujúci informácie o elektronickej diaľničnej známke. Nie sme oficiálnym predajcom e-známok, ale poskytovateľom informácií.</p>
            </div>

            <h3>2. Identifikácia prevádzkovateľa</h3>
            <p><strong>Názov:</strong> ezamki.com<br>
            <strong>IČO:</strong> 91533494<br>
            <strong>Adresa:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia<br>
            <strong>Email:</strong> info@ezamki.com<br>
            <strong>Telefón:</strong> +2670233649327</p>

            <h3>3. Aké osobné údaje zhromažďujeme</h3>
            <p>Pri používaní našej webovej stránky môžeme zbierať nasledujúce kategórie osobných údajov:</p>

            <h4>3.1 Údaje poskytnuté dobrovoľne</h4>
            <ul>
                <li><strong>Kontaktné údaje:</strong> meno, email, telefónne číslo (pri používaní kontaktného formulára)</li>
                <li><strong>Obsah komunikácie:</strong> správy, otázky a prípadné pripomienky, ktoré nám odošlete</li>
            </ul>

            <h4>3.2 Automaticky zbierané údaje</h4>
            <ul>
                <li><strong>Technické údaje:</strong> IP adresa, typ prehliadača, operačný systém</li>
                <li><strong>Údaje o používaní:</strong> navštívené stránky, čas návštevy, zdrojová stránka</li>
                <li><strong>Cookies:</strong> identifikátory uložené vo vašom prehliadači</li>
            </ul>

            <h3>4. Účel a právny základ spracovania</h3>
            <p>Vaše osobné údaje spracovávame na nasledujúce účely a na základe týchto právnych základov:</p>

            <h4>4.1 Poskytovanie informačných služieb</h4>
            <ul>
                <li><strong>Účel:</strong> Odpovedanie na vaše otázky a poskytovanie informácií</li>
                <li><strong>Právny základ:</strong> Oprávnený záujem (čl. 6 ods. 1 písm. f GDPR)</li>
                <li><strong>Doba uchovávania:</strong> 3 roky od poslednej komunikácie</li>
            </ul>

            <h4>4.2 Zlepšovanie webovej stránky</h4>
            <ul>
                <li><strong>Účel:</strong> Analýza návštevnosti a optimalizácia obsahu</li>
                <li><strong>Právny základ:</strong> Súhlas (čl. 6 ods. 1 písm. a GDPR)</li>
                <li><strong>Doba uchovávania:</strong> 26 mesiacov</li>
            </ul>

            <h4>4.3 Marketingová komunikácia</h4>
            <ul>
                <li><strong>Účel:</strong> Zasielanie informácií o nových článkoch a službách</li>
                <li><strong>Právny základ:</strong> Súhlas (čl. 6 ods. 1 písm. a GDPR)</li>
                <li><strong>Doba uchovávania:</strong> Do odvolania súhlasu</li>
            </ul>

            <h4>4.4 Plnenie zákonných povinností</h4>
            <ul>
                <li><strong>Účel:</strong> Dodržiavanie právnych predpisov</li>
                <li><strong>Právny základ:</strong> Právna povinnosť (čl. 6 ods. 1 písm. c GDPR)</li>
                <li><strong>Doba uchovávania:</strong> Podľa právnych predpisov (typicky 5-10 rokov)</li>
            </ul>

            <h3>5. Súbory cookies</h3>
            <p>Naša webová stránka používa cookies na zlepšenie vášho zážitku. Rozlišujeme nasledujúce typy cookies:</p>

            <h4>5.1 Nevyhnutné cookies</h4>
            <p>Tieto cookies sú potrebné pre správne fungovanie webovej stránky. Bez nich by stránka nefungovala správne.</p>
            <ul>
                <li>Trvanie: Do zatvorenia prehliadača (session cookies)</li>
                <li>Nezbierajú osobné údaje</li>
            </ul>

            <h4>5.2 Analytické cookies</h4>
            <p>Používame Google Analytics na pochopenie, ako návštevníci využívajú našu stránku.</p>
            <ul>
                <li>Poskytovateľ: Google LLC</li>
                <li>Trvanie: 26 mesiacov</li>
                <li>Účel: Analýza návštevnosti, používateľské správanie</li>
                <li>Právny základ: Súhlas</li>
            </ul>

            <h4>5.3 Marketingové cookies</h4>
            <p>Facebook Pixel nám pomáha merať efektivitu našich kampaní.</p>
            <ul>
                <li>Poskytovateľ: Meta Platforms Inc.</li>
                <li>Trvanie: 90 dní</li>
                <li>Účel: Retargeting, meranie konverzií</li>
                <li>Právny základ: Súhlas</li>
            </ul>

            <h4>5.4 Správa cookies</h4>
            <p>Cookies môžete spravovať prostredníctvom:</p>
            <ul>
                <li>Nášho cookie bannera pri prvej návšteve</li>
                <li>Nastavení vášho prehliadača</li>
                <li>Kontaktovaním nášho tímu</li>
            </ul>

            <h3>6. Zdieľanie osobných údajov</h3>
            <p>Vaše osobné údaje môžeme zdieľať s nasledujúcimi kategóriami príjemcov:</p>

            <h4>6.1 Poskytovatelia služieb</h4>
            <ul>
                <li><strong>Hosting služby:</strong> Uloženie webovej stránky a údajov</li>
                <li><strong>Email služby:</strong> Zasielanie emailov a správa komunikácie</li>
                <li><strong>Analytické nástroje:</strong> Google Analytics, Facebook Pixel</li>
            </ul>

            <h4>6.2 Orgány verejnej moci</h4>
            <p>V prípade potreby môžeme zdieľať údaje s:</p>
            <ul>
                <li>Políciou a justičnými orgánmi (pri vyšetrovaní trestnej činnosti)</li>
                <li>Daňovými orgánmi (pri plnení daňových povinností)</li>
                <li>Úradom na ochranu osobných údajov (pri kontrole dodržiavania GDPR)</li>
            </ul>

            <h4>6.3 Prenos do tretích krajín</h4>
            <p>Niektorí naši poskytovatelia služieb (napr. Google, Facebook) môžu prenášať údaje do USA. Tieto prenosy sú zabezpečené:</p>
            <ul>
                <li>Štandardnými zmluvnými doložkami EÚ</li>
                <li>Adekvátnym rozhodnutím Európskej komisie</li>
                <li>Príslušnými certifikáciami a zárukam</li>
            </ul>

            <h3>7. Vaše práva</h3>
            <p>Ako dotknutá osoba máte podľa GDPR nasledujúce práva:</p>

            <h4>7.1 Právo na prístup (čl. 15 GDPR)</h4>
            <p>Máte právo získať potvrdenie o tom, či spracovávame vaše osobné údaje, a ak áno, máte právo na prístup k týmto údajom.</p>

            <h4>7.2 Právo na opravu (čl. 16 GDPR)</h4>
            <p>Máte právo na opravu nesprávnych alebo doplnenie neúplných osobných údajov.</p>

            <h4>7.3 Právo na vymazanie - "právo byť zabudnutý" (čl. 17 GDPR)</h4>
            <p>Máte právo požadovať vymazanie osobných údajov, ak:</p>
            <ul>
                <li>Údaje už nie sú potrebné na účel, na ktorý boli zhromaždené</li>
                <li>Odvoláte súhlas a neexistuje iný právny základ</li>
                <li>Údaje boli spracované nezákonne</li>
                <li>Údaje musia byť vymazané podľa právnej povinnosti</li>
            </ul>

            <h4>7.4 Právo na obmedzenie spracovania (čl. 18 GDPR)</h4>
            <p>Máte právo požadovať obmedzenie spracovania v určitých prípadoch.</p>

            <h4>7.5 Právo na prenosnosť údajov (čl. 20 GDPR)</h4>
            <p>Máte právo získať osobné údaje v štruktúrovanom, bežne používanom a strojovo čitateľnom formáte.</p>

            <h4>7.6 Právo namietať (čl. 21 GDPR)</h4>
            <p>Máte právo namietať proti spracovaniu osobných údajov na základe oprávneného záujmu.</p>

            <h4>7.7 Právo podať sťažnosť</h4>
            <p>Máte právo podať sťažnosť na Úrad na ochranu osobných údajov Slovenskej republiky:</p>
            <ul>
                <li><strong>Adresa:</strong> Hraničná 12, 820 07 Bratislava 27</li>
                <li><strong>Web:</strong> www.dataprotection.gov.sk</li>
                <li><strong>Email:</strong> statny.dozor@pdp.gov.sk</li>
            </ul>

            <h4>7.8 Uplatnenie práv</h4>
            <p>Ak chcete uplatniť ktorékoľvek z týchto práv, kontaktujte nás na:</p>
            <ul>
                <li><strong>Email:</strong> info@ezamki.com</li>
                <li><strong>Pošta:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia</li>
            </ul>
            <p>Na vašu žiadosť odpovieme do 30 dní.</p>

            <h3>8. Bezpečnosť osobných údajov</h3>
            <p>Implementovali sme primerané technické a organizačné opatrenia na ochranu vašich osobných údajov:</p>

            <h4>8.1 Technické opatrenia</h4>
            <ul>
                <li>SSL/TLS šifrovanie komunikácie</li>
                <li>Firewall a antivírusová ochrana</li>
                <li>Pravidelné zálohovanie údajov</li>
                <li>Bezpečné heslá a autentifikácia</li>
                <li>Aktualizácie bezpečnostných záplat</li>
            </ul>

            <h4>8.2 Organizačné opatrenia</h4>
            <ul>
                <li>Prístup k údajom majú len oprávnené osoby</li>
                <li>Zmluvy o mlčanlivosti so zamestnancami</li>
                <li>Pravidelné školenia o ochrane údajov</li>
                <li>Plán reakcie na bezpečnostné incidenty</li>
            </ul>

            <h3>9. Uchovávanie osobných údajov</h3>
            <p>Osobné údaje uchovávame len po dobu nevyhnutnú na splnenie účelu, na ktorý boli zhromaždené:</p>
            <ul>
                <li><strong>Kontaktné formuláre:</strong> 3 roky od poslednej komunikácie</li>
                <li><strong>Analytické údaje:</strong> 26 mesiacov</li>
                <li><strong>Cookies:</strong> Podľa typu (session až 26 mesiacov)</li>
                <li><strong>Účtovné doklady:</strong> 10 rokov (zákonná povinnosť)</li>
            </ul>

            <h3>10. Automatizované rozhodovanie a profilovanie</h3>
            <p>Na našej webovej stránke nepoužívame automatizované rozhodovanie ani profilovanie, ktoré by malo právne účinky alebo by vás podobne významne ovplyvňovalo.</p>

            <h3>11. Deti a osoby mladšie ako 16 rokov</h3>
            <p>Naša webová stránka nie je určená pre deti mladšie ako 16 rokov. Vedome nezhromažďujeme osobné údaje od detí. Ak zistíme, že sme neúmyselne získali údaje od dieťaťa, okamžite ich vymažeme.</p>

            <h3>12. Zmeny tejto politiky</h3>
            <p>Túto Politiku ochrany osobných údajov môžeme čas od času aktualizovať. O významných zmenách vás budeme informovať:</p>
            <ul>
                <li>Zverejnením oznámenia na webovej stránke</li>
                <li>Emailom (ak máme vašu adresu)</li>
                <li>Aktualizáciou dátumu "Posledná aktualizácia" v hornej časti dokumentu</li>
            </ul>

            <h3>13. Kontaktné informácie</h3>
            <p>Ak máte akékoľvek otázky týkajúce sa tejto Politiky ochrany osobných údajov alebo spracovania vašich údajov, kontaktujte nás:</p>

            <div class='highlight-box'>
                <p><strong><i class='fas fa-envelope'></i> Email:</strong> info@ezamki.com</p>
                <p><strong><i class='fas fa-map-marker-alt'></i> Poštová adresa:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia</p>
                <p><strong><i class='fas fa-phone'></i> Telefón:</strong> +2670233649327</p>
                <p><strong><i class='fas fa-id-card'></i> IČO:</strong> 91533494</p>
            </div>

            <h3>14. Súhlas</h3>
            <p>Používaním našej webovej stránky potvrdzujete, že ste si prečítali a porozumeli tejto Politike ochrany osobných údajov. Ak nesúhlasíte s touto politikou, prosím nepoužívajte našu webovú stránku.</p>

            <p><em>Posledná aktualizácia: 1. január 2025</em></p>
        </div>
    </div>

    <footer>
        <div class='container'>
            <p>&copy; 2025 ezamki.com - Všetky práva vyhradené | <a href='index.php' style='color: #667eea;'>Domov</a></p>
        </div>
    </footer>
</body>
</html>