<?php
?>
<!DOCTYPE html>
<html lang='sk'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Podmienky používania - E-známka Slovensko</title>
    <meta name='description' content='Podmienky používania webovej stránky ezamki.com - pravidlá a podmienky pre používateľov.'>
    <link rel='icon' type='image/jpeg' href='images/logo.jpg'>
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css'>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.8;
            color: #333;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        header {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: #667eea;
        }
        
        .logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .logo h1 {
            font-size: 24px;
            font-weight: bold;
        }
        
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        
        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        nav a:hover {
            color: #667eea;
        }
        
        .page-hero {
            background: linear-gradient(rgba(102, 126, 234, 0.9), rgba(118, 75, 162, 0.9));
            color: white;
            padding: 60px 0;
            text-align: center;
        }
        
        .page-hero h2 {
            font-size: 42px;
            margin-bottom: 10px;
        }
        
        .main-content {
            background: white;
            margin: -30px auto 40px;
            border-radius: 20px;
            padding: 60px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            max-width: 900px;
        }
        
        .main-content h3 {
            color: #667eea;
            font-size: 26px;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        
        .main-content h4 {
            color: #764ba2;
            font-size: 20px;
            margin-top: 20px;
            margin-bottom: 10px;
        }
        
        .main-content p {
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .main-content ul, .main-content ol {
            margin: 15px 0;
            padding-left: 30px;
        }
        
        .main-content li {
            margin-bottom: 8px;
        }
        
        .highlight-box {
            background: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        
        .warning-box {
            background: #f8d7da;
            border-left: 5px solid #dc3545;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        
        footer {
            background: #2d3436;
            color: white;
            padding: 30px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }
            
            nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .main-content {
                padding: 30px 20px;
            }
            
            .page-hero h2 {
                font-size: 28px;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class='container'>
            <div class='header-content'>
                <a href='index.php' class='logo'>
                    <img src='images/logo.jpg' alt='E-známka Logo'>
                    <h1>E-známka SK</h1>
                </a>
                <nav>
                    <ul>
                        <li><a href='index.php'><i class='fas fa-home'></i> Domov</a></li>
                        <li><a href='blog.php'><i class='fas fa-blog'></i> Blog</a></li>
                        <li><a href='about.php'><i class='fas fa-users'></i> O nás</a></li>
                        <li><a href='contact.php'><i class='fas fa-envelope'></i> Kontakt</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class='page-hero'>
        <div class='container'>
            <h2><i class='fas fa-file-contract'></i> Podmienky používania</h2>
            <p>Všeobecné podmienky používania webovej stránky</p>
        </div>
    </section>

    <div class='container'>
        <div class='main-content'>
            <p><strong>Dátum účinnosti:</strong> 1. január 2025</p>
            <p><strong>Posledná aktualizácia:</strong> 1. január 2025</p>

            <h3>1. Všeobecné ustanovenia</h3>
            <p>Tieto Podmienky používania ("Podmienky") upravujú pravidlá používania webovej stránky ezamki.com ("Webová stránka", "Stránka") prevádzkovanej prevádzkovateľom s IČO 91533494 so sídlom Mišík Drive 86122, 572 56 Lipovec, Slovakia ("my", "nás", "náš").</p>

            <div class='warning-box'>
                <p><strong><i class='fas fa-exclamation-triangle'></i> Dôležité upozornenie:</strong> Táto webová stránka je iba informačný portál o elektronickej diaľničnej známke na Slovensku. Nepredávame ani nezabezpečujeme nákup e-známok. Pre oficiálny nákup e-známky navštívte www.eznamka.sk.</p>
            </div>

            <h3>2. Akceptácia podmienok</h3>
            <p>Prístupom na túto Webovú stránku a jej používaním vyjadrujete súhlas s týmito Podmienkami. Ak s týmito Podmienkami nesúhlasíte, nepoužívajte túto Webovú stránku.</p>

            <p>Podmienky môžeme kedykoľvek zmeniť alebo upraviť. Akékoľvek zmeny nadobudnú účinnosť okamžite po ich zverejnení na tejto Webovej stránke. Vaše pokračujúce používanie Stránky po zverejnení zmien znamená, že tieto zmeny akceptujete.</p>

            <h3>3. Popis služieb</h3>
            <p>Naša Webová stránka poskytuje:</p>
            <ul>
                <li>Informačné články o elektronickej diaľničnej známke na Slovensku</li>
                <li>Návody a FAQ týkajúce sa e-známky</li>
                <li>Informácie o pravidlách cestnej premávky</li>
                <li>Tipy pre turistov cestujúcich po Slovensku</li>
                <li>Blog s užitočnými radami pre vodičov</li>
            </ul>

            <h3>4. Obmedzenie zodpovednosti</h3>
            
            <h4>4.1 Informačný charakter</h4>
            <p>Všetky informácie na tejto Webovej stránke sú poskytované výlučne na informačné účely. Napriek našej snahe o presnosť a aktuálnosť informácií:</p>
            <ul>
                <li>Nezaručujeme úplnosť, presnosť alebo aktuálnosť informácií</li>
                <li>Informácie nemusia byť vždy aktualizované v reálnom čase</li>
                <li>Nemôžeme zaručiť, že informácie sú bez chýb</li>
                <li>Nezodpovedáme za rozhodnutia prijaté na základe informácií z našej Stránky</li>
            </ul>

            <h4>4.2 Nie sme oficiálny predajca</h4>
            <p>Dôrazne upozorňujeme, že:</p>
            <ul>
                <li>Nie sme oficiálnym predajcom e-známok</li>
                <li>Neposkytujeme služby nákupu e-známok</li>
                <li>Nezodpovedáme za proces nákupu e-známky na iných stránkach</li>
                <li>Pre oficiálny nákup navštívte www.eznamka.sk</li>
            </ul>

            <h4>4.3 Vyradenie záruky</h4>
            <p>Webová stránka sa poskytuje "TAK AKO JE" a "AKO JE K DISPOZÍCII" bez akýchkoľvek záruk, či už výslovných alebo implicitných, vrátane, ale nie výlučne, záruk predajnosti, vhodnosti na konkrétny účel alebo neporušenia práv.</p>

            <h4>4.4 Obmedzenie zodpovednosti za škody</h4>
            <p>V maximálnom rozsahu povolenom platným právom nezodpovedáme za žiadne priame, nepriame, náhodné, následné alebo špeciálne škody vyplývajúce z:</p>
            <ul>
                <li>Používania alebo nemožnosti používať Webovú stránku</li>
                <li>Spoľahnutia sa na informácie uvedené na Stránke</li>
                <li>Chýb alebo nepresností v obsahu</li>
                <li>Neoprávneného prístupu k vašim údajom</li>
                <li>Prerušenia alebo ukončenia služby</li>
            </ul>

            <h3>5. Odkazy na tretie strany</h3>
            <p>Naša Webová stránka môže obsahovať odkazy na webové stránky tretích strán, ktoré nie sú v našom vlastníctve ani pod našou kontrolou. Nemáme kontrolu nad obsahom, politikami ochrany súkromia ani praktikami webových stránok tretích strán a neprijímame za ne žiadnu zodpovednosť.</p>

            <p>Dôrazne vám odporúčame prečítať si podmienky používania a politiky ochrany súkromia každej webovej stránky tretích strán, ktorú navštívite.</p>

            <h3>6. Duševné vlastníctvo</h3>
            
            <h4>6.1 Autorské práva</h4>
            <p>Veškerý obsah prítomný na tejto Webovej stránke, vrátane, ale nie výlučne, textu, grafiky, loga, obrázkov, videí, zvukových klipov, digitálnych sťahovaní a kompilácií údajov, je majetkom prevádzkovateľa alebo jeho poskytovateľov obsahu a je chránený slovenskými a medzinárodnými zákonmi o autorských právach.</p>

            <h4>6.2 Ochranné známky</h4>
            <p>Názov "E-známka SK" a súvisiace logá sú naše obchodné názvy alebo ochranné známky. Iné ochranné známky, názvy produktov a služieb, logá a mená spoločností uvedené na Webovej stránke sú majetkom ich príslušných vlastníkov.</p>

            <h4>6.3 Povolené používanie</h4>
            <p>Smete:</p>
            <ul>
                <li>Prezerať obsah Webovej stránky pre osobnú, nekomerčnú potrebu</li>
                <li>Vytlačiť si kópie článkov pre osobné použitie</li>
                <li>Zdieľať odkazy na naše články na sociálnych sieťach</li>
            </ul>

            <h4>6.4 Zakázané používanie</h4>
            <p>Bez nášho predchádzajúceho písomného súhlasu nesmete:</p>
            <ul>
                <li>Reprodukovať, kopírovať alebo šíriť obsah na komerčné účely</li>
                <li>Upravovať alebo vytvárať odvodené diela z obsahu</li>
                <li>Používať náš obsah na iných webových stránkach bez uvedenia zdroja</li>
                <li>Odstraňovať autorské poznámky z obsahu</li>
                <li>Používať automatizované systémy na kopírovanie obsahu</li>
            </ul>

            <h3>7. Pravidlá správania používateľov</h3>
            <p>Pri používaní našej Webovej stránky sa zaväzujete, že nebudete:</p>

            <ul>
                <li>Porušovať žiadne platné zákony alebo predpisy</li>
                <li>Zneužívať alebo škodiť neplnoletým osobám</li>
                <li>Vydávať sa za inú osobu alebo subjekt</li>
                <li>Nahrávať vírusy, malvér alebo iný škodlivý kód</li>
                <li>Obťažovať, zneužívať alebo škodiť inej osobe</li>
                <li>Zhromažďovať osobné údaje iných používateľov</li>
                <li>Zasahovať do bezpečnostných funkcií Webovej stránky</li>
                <li>Používať Webovú stránku na neoprávnené reklamné účely</li>
                <li>Zaťažovať infraštruktúru nadmerným počtom požiadaviek</li>
            </ul>

            <h3>8. Používateľom generovaný obsah</h3>
            
            <h4>8.1 Komentáre a späťná väzba</h4>
            <p>Ak nám odošlete komentáre, návrhy, otázky alebo inú spätnú väzbu ("Späť väzba"), súhlasíte s tým, že:</p>
            <ul>
                <li>Vaša Späťná väzba neporušuje práva tretích strán</li>
                <li>Môžeme použiť vašu Späťnú väzbu bez akýchkoľvek obmedzení</li>
                <li>Nemáte nárok na kompenzáciu za Spätnú väzbu</li>
            </ul>

            <h4>8.2 Moderovanie obsahu</h4>
            <p>Vyhradzujeme si právo:</p>
            <ul>
                <li>Monitorovať všetok používateľom generovaný obsah</li>
                <li>Odmietnuť alebo odstrániť akýkoľvek obsah podľa nášho uváženia</li>
                <li>Ukončiť prístup používateľom, ktorí porušujú tieto Podmienky</li>
            </ul>

            <h3>9. Dostupnosť služby</h3>
            <p>Snažíme sa zabezpečiť, aby bola Webová stránka dostupná 24 hodín denne, 7 dní v týždni. Avšak:</p>
            <ul>
                <li>Nemôžeme zaručiť neprerušenú dostupnosť</li>
                <li>Môžeme kedykoľvek prerušiť službu pre údržbu</li>
                <li>Nezodpovedáme za výpadky spôsobené technickými problémami</li>
                <li>Môžeme kedykoľvek ukončiť alebo zmeniť službu bez predchádzajúceho upozornenia</li>
            </ul>

            <h3>10. Ochrana osobných údajov</h3>
            <p>Spracovanie vašich osobných údajov je upravené našou <a href='privacy-policy.php' style='color: #667eea;'>Politikou ochrany osobných údajov</a>, ktorá tvorí neoddeliteľnú súčasť týchto Podmienok.</p>

            <h3>11. Ukončenie</h3>
            <p>Môžeme okamžite ukončiť alebo pozastaviť váš prístup k Webovej stránke bez predchádzajúceho upozornenia alebo zodpovednosti, z akéhokoľvek dôvodu, vrátane, ale nie výlučne, ak porušíte tieto Podmienky.</p>

            <p>Po ukončení vaše právo používať Webovú stránku okamžite zaniká.</p>

            <h3>12. Odškodnenie</h3>
            <p>Súhlasíte s tým, že nás budete odškodňovať, chrániť a zbaviť zodpovednosti pred akýmikoľvek nárokmi, záväzkami, škodami, stratami a výdavkami, vrátane primeraných právnych poplatkov, vyplývajúcimi z:</p>
            <ul>
                <li>Vášho porušenia týchto Podmienok</li>
                <li>Vášho porušenia akýchkoľvek práv tretích strán</li>
                <li>Vášho používania Webovej stránky</li>
            </ul>

            <h3>13. Rozhodné právo a riešenie sporov</h3>
            
            <h4>13.1 Rozhodné právo</h4>
            <p>Tieto Podmienky sa riadia a vykladajú v súlade so zákonmi Slovenskej republiky bez ohľadu na kolízne normy.</p>

            <h4>13.2 Právomoc súdov</h4>
            <p>Akékoľvek spory vyplývajúce z týchto Podmienok alebo súvisiace s nimi budú výlučne podliehať právomoci súdov Slovenskej republiky.</p>

            <h4>13.3 Alternatívne riešenie sporov</h4>
            <p>Pred začatím súdneho konania vás žiadame, aby ste nás kontaktovali a pokúsili sa spor vyriešiť mimosúdne. Môžete nás kontaktovať na info@ezamki.com.</p>

            <h3>14. Deliteľnosť ustanovení</h3>
            <p>Ak sa akékoľvek ustanovenie týchto Podmienok považuje za neplatné alebo nevykonateľné, takéto ustanovenie bude zmenené a vykladané tak, aby čo najpresnejšie zodpovedalo pôvodným cieľom, a ostatné ustanovenia zostanú v plnej platnosti a účinnosti.</p>

            <h3>15. Celá dohoda</h3>
            <p>Tieto Podmienky spolu s našou Politikou ochrany osobných údajov predstavujú celú dohodu medzi vami a nami týkajúcu sa používania Webovej stránky a nahrádzajú všetky predchádzajúce dohody a porozumenia.</p>

            <h3>16. Kontaktné informácie</h3>
            <p>Ak máte akékoľvek otázky týkajúce sa týchto Podmienok, kontaktujte nás:</p>

            <div class='highlight-box'>
                <p><strong><i class='fas fa-envelope'></i> Email:</strong> info@ezamki.com</p>
                <p><strong><i class='fas fa-map-marker-alt'></i> Poštová adresa:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia</p>
                <p><strong><i class='fas fa-phone'></i> Telefón:</strong> +2670233649327</p>
                <p><strong><i class='fas fa-id-card'></i> IČO:</strong> 91533494</p>
            </div>

            <h3>17. Jazyk</h3>
            <p>Tieto Podmienky sú napísané v slovenskom jazyku. V prípade akéhokoľvek rozporu medzi slovenskou verziou a prekladom do iného jazyka má prednosť slovenská verzia.</p>

            <h3>18. Vzťah strán</h3>
            <p>Nič v týchto Podmienkach nevytvára partnerstvo, spoločné podnikanie, pracovný vzťah alebo agentúrny vzťah medzi vami a nami.</p>

            <h3>19. Postúpenie</h3>
            <p>Nemôžete postúpiť ani preniesť tieto Podmienky alebo akékoľvek práva alebo povinnosti z nich vyplývajúce bez nášho predchádzajúceho písomného súhlasu. Môžeme voľne postúpiť alebo preniesť tieto Podmienky.</p>

            <h3>20. Vzdanie sa práva</h3>
            <p>Naše nevykonanie alebo oneskorenie pri výkone akéhokoľvek práva alebo ustanovenia týchto Podmienok nepredstavuje vzdanie sa takého práva alebo ustanovenia.</p>

            <p><strong>Akceptáciou týchto Podmienok potvrdzujete, že ste si ich prečítali, porozumeli im a súhlasíte s nimi.</strong></p>

            <p><em>Posledná aktualizácia: 1. január 2025</em></p>
        </div>
    </div>

    <footer>
        <div class='container'>
            <p>&copy; 2025 ezamki.com - Všetky práva vyhradené | <a href='index.php' style='color: #667eea;'>Domov</a></p>
        </div>
    </footer>
</body>
</html>